﻿namespace Microsoft.Samples.PlanMyNight.Infrastructure.Mvc
{
    using System;
    using System.Linq.Expressions;
    using System.Web.Mvc;
    using System.Web.Routing;

    public static class MvcExtensions
    {
        public static string BuildUrlFromExpression<T>(this Controller controller, Expression<Action<T>> action) where T : Controller
        {
            return LinkBuilder.BuildUrlFromExpression<T>(
                            controller.ControllerContext.RequestContext,
                            controller.Url.RouteCollection,
                            action);
        }

        public static string GetAbsoluteUrl(this ControllerBase controller, string path)
        {
            return String.Concat(controller.ControllerContext.HttpContext.Request.Url.Scheme, "://", controller.ControllerContext.HttpContext.Request.ServerVariables["HTTP_HOST"], path);
        }

        public static bool IsAjaxCall(this Controller controller)
        {
            return !string.IsNullOrEmpty(controller.Request.ContentType) && controller.Request.ContentType.Contains("application/json");
        }

        public static string GetReturnUrl(this Controller controller)
        {
            if (controller.Request.ServerVariables != null && !String.IsNullOrEmpty(controller.Request.ServerVariables["HTTP_REFERER"]))
                return controller.Request.ServerVariables["HTTP_REFERER"];

            return "~/";
        }
    }
}
